/*
 * Decompiled with CFR 0.152.
 */
package com.coupon.controller;

import com.coupon.service.CouponService;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@ApiIgnore
@RestController
@RequestMapping(value={"/coupon"})
public class Coupon {
    private static final String tokenHeader = "token";
    private final CouponService service;

    public Coupon(CouponService service) {
        this.service = service;
    }

    @PostMapping(value={"/authenticate"})
    public Object authenticate(@RequestBody Object body) {
        return this.service.postToAPI(body, "api/Authentication/authenticate", null);
    }

    @PostMapping(value={"/itemOrderByOTP"})
    public Object itemOrderByOTP(@RequestBody Object body, @RequestHeader(name="token") String jwtToken) {
        return this.service.postToAPI(body, "inquiry/itemorderbyotp", jwtToken);
    }

    @PostMapping(value={"/purchaseInquiryByOTP"})
    public Object purchaseInquiryByOTP(@RequestBody Object body, @RequestHeader(name="token") String jwtToken) {
        return this.service.postToAPI(body, "inquiry/purchaseinquirybyotp", jwtToken);
    }

    @PostMapping(value={"/confirmOrderByOTP"})
    public Object confirmOrderByOTP(@RequestBody Object body, @RequestHeader(name="token") String jwtToken) {
        return this.service.postToAPI(body, "payment/confirmorderbyotp", jwtToken);
    }

    @PostMapping(value={"/reverseOrderByOTP"})
    public Object reverseOrderByOTP(@RequestBody Object body, @RequestHeader(name="token") String jwtToken) {
        return this.service.postToAPI(body, "payment/reverseorderbyotp", jwtToken);
    }

    @PostMapping(value={"/orderCancellationByOTP"})
    public Object orderCancellationByOTP(@RequestBody Object body, @RequestHeader(name="token") String jwtToken) {
        return this.service.postToAPI(body, "payment/ordercancelationbyotp", jwtToken);
    }
}

